<?php
/*
Plugin Name: Thống Kê Truy Cập - SB MEDIA
Plugin URI: https://sbmedia.com.vn/thong-ke-truy-cap
Description: Plugin thống kê truy cập (Online, Hôm nay, Hôm qua, Tuần, Tháng, Tổng).
Version: 1.0.0
Author: Dev SB MEDIA
Author URI: https://sbmedia.com.vn
License: GPLv2 or later
License URI: https://sbmedia.com.vn/plugin
Text Domain: thong-ke-truy-cap
Domain Path: /languages
*/


if ( ! defined( 'ABSPATH' ) ) exit;

class TK_Thong_Ke_Truy_Cap {

    public function __construct() {
        register_activation_hook(__FILE__, array($this, 'create_table'));
        add_action('init', array($this, 'track_visitor'));
        add_shortcode('thong_ke_truy_cap', array($this, 'render_stats'));
    }

    public function create_table() {
        global $wpdb;
        $table = $wpdb->prefix . 'tk_truycap';
        $charset = $wpdb->get_charset_collate();

        $sql = "CREATE TABLE IF NOT EXISTS $table (
            id BIGINT(20) UNSIGNED AUTO_INCREMENT PRIMARY KEY,
            ip VARCHAR(50),
            time INT(11)
        ) $charset;";

        require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
        dbDelta($sql);
    }

    public function track_visitor() {
        if ( is_admin() ) return;

        global $wpdb;
        $table = $wpdb->prefix . 'tk_truycap';
        $ip = sanitize_text_field($_SERVER['REMOTE_ADDR']);
        $time = time();

        $wpdb->insert($table, array(
            'ip'   => $ip,
            'time' => $time
        ));
    }

    public function get_stats() {
        global $wpdb;
        $table = $wpdb->prefix . 'tk_truycap';
        $time_now = time();

        $online   = $wpdb->get_var("SELECT COUNT(DISTINCT ip) FROM $table WHERE time > ($time_now - 300)");
        $today    = strtotime("today");
        $homnay   = $wpdb->get_var("SELECT COUNT(*) FROM $table WHERE time >= $today");

        $yesterday_start = strtotime("yesterday");
        $yesterday_end   = strtotime("today");
        $homqua          = $wpdb->get_var("SELECT COUNT(*) FROM $table WHERE time >= $yesterday_start AND time < $yesterday_end");

        $week_start = strtotime("monday this week");
        $tuan       = $wpdb->get_var("SELECT COUNT(*) FROM $table WHERE time >= $week_start");

        $month_start = strtotime(date("Y-m-01 00:00:00"));
        $thang       = $wpdb->get_var("SELECT COUNT(*) FROM $table WHERE time >= $month_start");

        $tong = $wpdb->get_var("SELECT COUNT(*) FROM $table");

        return compact('online', 'homnay', 'homqua', 'tuan', 'thang', 'tong');
    }

    public function render_stats() {
        $stats = $this->get_stats();

        ob_start(); ?>
        <div class="tk-thongke">
            <p>👥 Đang online: <?php echo intval($stats['online']); ?></p>
            <p>📅 Hôm nay: <?php echo intval($stats['homnay']); ?></p>
            <p>📅 Hôm qua: <?php echo intval($stats['homqua']); ?></p>
            <p>📊 Tuần này: <?php echo intval($stats['tuan']); ?></p>
            <p>📈 Tháng này: <?php echo intval($stats['thang']); ?></p>
            <p>🔢 Tổng truy cập: <?php echo intval($stats['tong']); ?></p>
        </div>
        <?php
        return ob_get_clean();
    }
}

new TK_Thong_Ke_Truy_Cap();
